/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ActionOnWakeUp;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.DisableRegenPower;
import io.github.apace100.origins.power.ElytraFlightPower;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.InventoryPower;
import io.github.apace100.origins.power.ModifyExhaustionPower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.RestrictArmorPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModDamageSources;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements INameable,
ICommandSource {
    @Shadow
    protected boolean field_204230_bP;
    @Shadow
    @Final
    public PlayerInventory field_71071_by;

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract EntitySize func_213305_a(Pose var1);

    @Shadow
    public abstract ItemStack func_184582_a(EquipmentSlotType var1);

    @Shadow
    public abstract ItemEntity func_71019_a(ItemStack var1, boolean var2);

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(method={"updateSwimming"}, at={@At(value="TAIL")})
    private void updateSwimmingPower(CallbackInfo ci) {
        if (OriginComponent.hasPower((Entity)this, SwimmingPower.class)) {
            this.func_204711_a(this.func_70051_ag() && !this.func_184218_aH());
            this.field_70171_ac = this.func_203007_ba();
            if (this.func_203007_ba()) {
                this.field_70143_R = 0.0f;
                Vector3d look = this.func_70040_Z();
                this.func_213315_a(MoverType.SELF, new Vector3d(look.field_72450_a / 4.0, look.field_72448_b / 4.0, look.field_72449_c / 4.0));
            }
        } else if (OriginComponent.hasPower((Entity)this, IgnoreWaterPower.class)) {
            this.func_204711_a(false);
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    private void invokeWakeUpAction(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (!bl && !updateSleepingPlayers && this.func_213374_dv().isPresent()) {
            BlockPos sleepingPos = (BlockPos)this.func_213374_dv().get();
            OriginComponent.getPowers((Entity)this, ActionOnWakeUp.class).stream().filter(p -> p.doesApply(sleepingPos)).forEach(p -> p.executeActions(sleepingPos, Direction.DOWN));
        }
    }

    @Inject(method={"canFoodHeal"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableHeal(CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.hasPower((Entity)this, DisableRegenPower.class)) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExhaustion"}, ordinal=0, name={"exhaustion"})
    private float modifyExhaustion(float exhaustionIn) {
        return OriginComponent.modify((Entity)this, ModifyExhaustionPower.class, exhaustionIn);
    }

    @Inject(at={@At(value="HEAD")}, method={"slowMovement"}, cancellable=true)
    public void slowMovement(BlockState state, Vector3d multiplier, CallbackInfo info) {
        if (PowerTypes.NO_COBWEB_SLOWDOWN.isActive((Entity)this) || PowerTypes.MASTER_OF_WEBS_NO_SLOWDOWN.isActive((Entity)this)) {
            info.cancel();
        }
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void dropAdditionalInventory(CallbackInfo ci) {
        OriginComponent.getPowers((Entity)this, InventoryPower.class).forEach(inventory -> {
            if (inventory.shouldDropOnDeath()) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack itemStack = inventory.func_70301_a(i);
                    if (!inventory.shouldDropOnDeath(itemStack)) continue;
                    if (!itemStack.func_190926_b() && EnchantmentHelper.func_190939_c((ItemStack)itemStack)) {
                        inventory.func_70304_b(i);
                        continue;
                    }
                    ((PlayerEntity)this).func_146097_a(itemStack, true, false);
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        });
    }

    @Inject(method={"canEquip"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventArmorDispensing(ItemStack stack, CallbackInfoReturnable<Boolean> info) {
        EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)stack);
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)this);
        if (component.getPowers(RestrictArmorPower.class).stream().anyMatch(rap -> !rap.canEquip(stack, slot))) {
            info.setReturnValue((Object)false);
        }
        if (stack.func_77973_b() == Items.field_185160_cR && OriginComponent.getPowers((Entity)this, ElytraFlightPower.class).size() > 0) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        if (PowerTypes.WATER_BREATHING.isActive((Entity)this)) {
            if (!(this.func_208600_a((ITag)FluidTags.field_206959_a) || this.func_70644_a(Effects.field_76427_o) || this.func_70644_a(Effects.field_205136_C))) {
                if (!this.isRainingAtPlayerPosition()) {
                    int landGain = this.func_207300_l(0);
                    this.func_70050_g(this.func_70682_h(this.func_70086_ai()) - landGain);
                    if (this.func_70086_ai() == -20) {
                        this.func_70050_g(0);
                        for (int i = 0; i < 8; ++i) {
                            double f = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double g = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            double h = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226282_d_(0.5), this.func_226280_cw_() + this.field_70146_Z.nextGaussian() * 0.08, this.func_226287_g_(0.5), f * 0.5, g * 0.5 + 0.25, h * 0.5);
                        }
                        this.func_70097_a(ModDamageSources.NO_WATER_FOR_GILLS, 2.0f);
                    }
                } else {
                    int landGain = this.func_207300_l(0);
                    this.func_70050_g(this.func_70086_ai() - landGain);
                }
            } else if (this.func_70086_ai() < this.func_205010_bg()) {
                this.func_70050_g(this.func_207300_l(this.func_70086_ai()));
            }
        }
    }

    private boolean isRainingAtPlayerPosition() {
        BlockPos blockPos = this.func_233580_cy_();
        return this.field_70170_p.func_175727_C(blockPos) || this.field_70170_p.func_175727_C(blockPos.func_177963_a(0.0, (double)this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b, 0.0));
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSubmergedIn(Lnet/minecraft/tag/Tag;)Z"), method={"updateTurtleHelmet"})
    public boolean isSubmergedInProxy(PlayerEntity player, ITag<Fluid> fluidTag) {
        boolean submerged = this.func_208600_a(fluidTag);
        if (PowerTypes.WATER_BREATHING.isActive((Entity)this)) {
            return !submerged;
        }
        return submerged;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;onAttacking(Lnet/minecraft/entity/Entity;)V")}, method={"attack"})
    public void cobwebOnMeleeAttack(Entity target, CallbackInfo info) {
        BlockPos targetPos;
        CooldownPower power;
        if (target instanceof LivingEntity && PowerTypes.WEBBING.isActive((Entity)this) && !this.func_225608_bj_() && (power = PowerTypes.WEBBING.get((Entity)this)).canUse() && (this.field_70170_p.func_175623_d(targetPos = target.func_233580_cy_()) || this.field_70170_p.func_180495_p(targetPos).func_185904_a().func_76222_j())) {
            this.field_70170_p.func_175656_a(targetPos, ModBlocks.TEMPORARY_COBWEB.func_176223_P());
            power.use();
        }
    }
}

